	function [D] = lp_d_func(Z,NIN,z0_sqred)
	% 
	% Calculates the D value in the Z_frequency point z0^2.
	% The D function is used for finding arc minimums for
	% the lowpass filter case. 
	% Other input arguments are the number of attenuation 
	% poles at infinity NIN and the attenuation pole vector Z.
	
	% Author: 			Per Loewenborg
    % Modified by:		LW 
	% Copyright:		by authors - not released for commercial use
	% Version: 			1	
	% Known bugs:		None
	% Report bugs to:	larsw@isy.liu.se

	D = (NIN/2)*(1/(1-z0_sqred)) + sum(Z./((Z.^2)-z0_sqred));
	
	
